<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use App\User;
use App\Stock;
use Auth;
use Theme;
use Input;
use Validator;

class StockController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
	
    public function index()
    {
        //
    }
    public function GET_listStock()
    {
      $theme = Theme::uses('notebook')->layout('default');
      $theme->asset()->container('post-scripts')->usePath()->add('laravel', 'js/laravel.js');
      $theme->setMenu('stock.list');
	  
     // $StockCombo =[''=>''] + stock::distinct()->select('IdComp')->get()->lists('IdComp','IdComp')->all();
     /* $data = stock::distinct()->select('IdComp')
            ->whereExists(function($query)
            {
                $query->select(DB::raw(1))
                      ->from('MasterGroupComp')
                      ->whereRaw('StockMC.IdComp collate database_default = MasterGroupComp.IdComp')
					  ->whereRaw('FlagActive = 1')
					  ->whereRaw('IdGroupComp = '.Auth::user()->IdGroupComp);
            })
            ->get(); */
      $data = DB::table('MasterComp')
			  ->join('MasterGroupComp','MasterGroupComp.IdComp','=','MasterComp.IdComp')
			  ->select('MasterComp.IdComp','DescComp')
			  ->where('MasterGroupComp.IdGroupComp', Auth::user()->IdGroupComp)
			  ->where('FlagActive','1')
			  ->get();		
      $StockCombo = [''=>'All Comp']+collect($data)->lists('DescComp','IdComp')->all(); 

      //$stock = Stock::paginate(25);
      $stock = DB::table('StockMC')
              ->join('MasterGroupComp', 'StockMC.IdComp', 'collate database_default =', 'MasterGroupComp.IdComp')
              ->join('MasterBrand', 'MasterBrand.DescBrand', 'collate database_default =', 'StockMC.Brand')
	      ->join('MasterGroupBrand', 'MasterGroupBrand.IdBrand', '=', 'MasterBrand.IdBrand')
              ->select('StockMC.IdComp','StockMC.ItemCode','WhName','Brand','OnHand','Commited','OnOrder','Price')
	      ->where('MasterGroupComp.FlagActive', '1')
	      ->where('MasterGroupBrand.FlagActive', '1')
              ->where('MasterGroupComp.IdGroupComp', Auth::user()->IdGroupComp)
	      ->where('MasterGroupBrand.IdGroupBrand', Auth::user()->IdGroupBrand)
              ->paginate(10);

      $params = array('getstock' => $stock, 'ParamIdComp' => '',
											'ParamItemCode' => '',
											'ParamBrand' => '', 
											'StockCombo' => $StockCombo);
      return $theme->scope('stock.3list', $params)->render();
    }
	
	public function FilterlistStock3()
    {
		$theme = Theme::uses('notebook')->layout('default');
		$theme->asset()->container('post-scripts')->usePath()->add('laravel', 'js/laravel.js');
		$theme->setMenu('stock.list.filter');
		
		/*$stock = Stock::where('IdComp','like','%'.Input::get('IdComp').'%')
				->where('ItemCode','like','%'.Input::get('ItemCode').'%')
				->where('Brand','like','%'.Input::get('Brand').'%')
				->paginate(25);*/
		
	     $stock = DB::table('StockMC')
              ->join('MasterGroupComp', 'StockMC.IdComp', 'collate database_default =', 'MasterGroupComp.IdComp')
              ->join('MasterBrand', 'MasterBrand.DescBrand', 'collate database_default =', 'StockMC.Brand')
			  ->join('MasterGroupBrand', 'MasterGroupBrand.IdBrand', '=', 'MasterBrand.IdBrand')
              ->select('StockMC.IdComp','StockMC.ItemCode','WhName','Brand','OnHand','Commited','OnOrder','Price')
			  ->where('MasterGroupComp.FlagActive', '1')
			  ->where('MasterGroupBrand.FlagActive', '1')
              ->where('MasterGroupComp.IdGroupComp', Auth::user()->IdGroupComp)
			  ->where('MasterGroupBrand.IdGroupBrand', Auth::user()->IdGroupBrand)
			  ->where('StockMC.IdComp','like','%'.Input::get('IdComp').'%')
			  ->where('StockMC.ItemCode','like','%'.Input::get('ItemCode').'%')
			  ->where('StockMC.Brand','like','%'.Input::get('Brand').'%')
              ->paginate(10);
		
		// $StockCombo = [''=>'All Comp'] + stock::distinct()->select('IdComp')->get()->lists('IdComp','IdComp')->all();
		/*$data = stock::distinct()->select('IdComp')
            ->whereExists(function($query)
            {
                $query->select(DB::raw(1))
                      ->from('MasterGroupComp')
                      ->whereRaw('StockMC.IdComp collate database_default = MasterGroupComp.IdComp')
					  ->whereRaw('FlagActive = 1')
					  ->whereRaw('IdGroupComp = '.Auth::user()->IdGroupComp);
            })
            ->get(); */
	  $data = DB::table('MasterComp')
			  ->join('MasterGroupComp','MasterGroupComp.IdComp','=','MasterComp.IdComp')
			  ->select('MasterComp.IdComp','DescComp')
			  ->where('MasterGroupComp.IdGroupComp', Auth::user()->IdGroupComp)
			  ->where('FlagActive','1')
			  ->get();
		
	    $StockCombo = [''=>'All Comp']+collect($data)->lists('DescComp','IdComp')->all(); 

		
		
		$params = array('getstock' => $stock, 'ParamIdComp' => Input::get('IdComp'),
											  'ParamItemCode' => Input::get('ItemCode'),
											  'ParamBrand' => Input::get('Brand'),
											  'StockCombo' => $StockCombo);

		return $theme->scope('stock.3list', $params)->render();
    }
	
	/*
	public function FilterlistStock2($id=null,$id2=null)
    {
		$theme = Theme::uses('notebook')->layout('default');
		$theme->asset()->container('post-scripts')->usePath()->add('laravel', 'js/laravel.js');
		$theme->setMenu('stock.list.filter');
		
		// $user = Auth::user();
		
		if (!isset($id)){
			$id =Input::get('IdComp');
		}
		elseif ($id == 'All')
		{
			$id ='';
		}
		
		if (!isset($id2)){
			$id2 =Input::get('ItemCode');
		}
		elseif ($id2 == 'All')
		{
			$id2 ='';
		}
			  
		$stock = Stock::where('IdComp','like','%'.$id.'%')
				->where('ItemCode','like','%'.$id2.'%')
				->paginate(10);
		
		$params = array('getstock' => $stock, 'ParamIdComp' => $id,'ParamItemCode' => $id2);
		
		if ($id==''){$id = 'All';}
		if ($id2==''){$id2 = 'All';}
		$stock->setPath('/stock/list/filter2/'.$id.'/'.$id2);

		return $theme->scope('stock.2list', $params)->render();
    }
	*/
	 
    
}
