<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use App\User;
use App\StockSP;
use Auth;
use Theme;
use Input;
use Validator;

class StockspController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
	
    public function index()
    {
        //
    }
    public function GET_listStock()
    {
      $theme = Theme::uses('notebook')->layout('default');
      $theme->asset()->container('post-scripts')->usePath()->add('laravel', 'js/laravel.js');
      $theme->setMenu('stocksp.list');
	  
	//$StockCombo =[''=>''] + stockSP::distinct()->select('IdComp')->get()->lists('IdComp','IdComp')->all();
	$data = DB::table('MasterComp')
			  ->join('MasterGroupComp','MasterGroupComp.IdComp','=','MasterComp.IdComp')
			  ->select('MasterComp.IdComp','DescComp')
			  ->where('MasterGroupComp.IdGroupComp', Auth::user()->IdGroupComp)
			  ->where('FlagActive','1')
			  ->get();
	  
	$StockCombo = [''=>'--All Comp--']+collect($data)->lists('DescComp','IdComp')->all(); 

	//$stock = StockSP::paginate(25);
	$stock = DB::table('StockSP')
			->join('MasterGroupComp', 'StockSP.IdComp', 'collate database_default =', 'MasterGroupComp.IdComp')
			->join('MasterBrand', 'MasterBrand.DescBrand', 'collate database_default =', 'StockSP.Brand')
			->join('MasterGroupBrand', 'MasterGroupBrand.IdBrand', '=', 'MasterBrand.IdBrand')
			->select('StockSP.IdComp','StockSP.ItemCode','WhName','Brand','OnHand','Commited','OnOrder','Price')
			->where('MasterGroupComp.FlagActive', '1')
			->where('MasterGroupBrand.FlagActive', '1')
			->where('MasterGroupComp.IdGroupComp', Auth::user()->IdGroupComp)
			->where('MasterGroupBrand.IdGroupBrand', Auth::user()->IdGroupBrand)
			->paginate(10);
      // $params = array('getstock' => $stock);
	 $params = array('getstock' => $stock, 'ParamIdComp' => '',
											'ParamItemCode' => '',
											'ParamBrand' => '', 
											'StockCombo' => $StockCombo);
      return $theme->scope('stocksp.list', $params)->render();
    }
	
	public function FilterlistStock()
    {
      $theme = Theme::uses('notebook')->layout('default');
      $theme->asset()->container('post-scripts')->usePath()->add('laravel', 'js/laravel.js');
      $theme->setMenu('stocksp.list');
	
		/*
		$stock = StockSP::where('IdComp','like','%'.Input::get('IdComp').'%')
				->where('ItemCode','like','%'.Input::get('ItemCode').'%')
				->where('Brand','like','%'.Input::get('Brand').'%')
				->paginate(25);
		
		$StockCombo = [''=>''] + stockSP::distinct()->select('IdComp')->get()->lists('IdComp','IdComp')->all();
		*/
	  $data = DB::table('MasterComp')
	  	->join('MasterGroupComp','MasterGroupComp.IdComp','=','MasterComp.IdComp')
		->select('MasterComp.IdComp','DescComp')
	 	->where('MasterGroupComp.IdGroupComp', Auth::user()->IdGroupComp)
	 	->where('FlagActive','1')
	  	->get();

	$StockCombo = [''=>'--All Comp--']+collect($data)->lists('DescComp','IdComp')->all(); 

	$stock = DB::table('StockSP')
              	->join('MasterGroupComp', 'StockSP.IdComp', 'collate database_default =', 'MasterGroupComp.IdComp')
              	->join('MasterBrand', 'MasterBrand.DescBrand', 'collate database_default =', 'StockSP.Brand')
		->join('MasterGroupBrand', 'MasterGroupBrand.IdBrand', '=', 'MasterBrand.IdBrand')
              	->select('StockSP.IdComp','StockSP.ItemCode','WhName','Brand','OnHand','Commited','OnOrder','Price')
		->where('MasterGroupComp.FlagActive', '1')
		->where('MasterGroupBrand.FlagActive', '1')
              	->where('MasterGroupComp.IdGroupComp', Auth::user()->IdGroupComp)
		->where('MasterGroupBrand.IdGroupBrand', Auth::user()->IdGroupBrand)
		->where('StockSP.IdComp','like','%'.Input::get('IdComp').'%')
		->where('StockSP.ItemCode','like','%'.Input::get('ItemCode').'%')
		->where('StockSP.Brand','like','%'.Input::get('Brand').'%')
              	->paginate(10);

		
		$params = array('getstock' => $stock, 'ParamIdComp' => Input::get('IdComp'),
											  'ParamItemCode' => Input::get('ItemCode'),
											  'ParamBrand' => Input::get('Brand'),
											  'StockCombo' => $StockCombo);

      //$params = array('getstock' => $stock);
      return $theme->scope('stocksp.list', $params)->render();
    }
	
}
